function [theta, logL]=EstimateTDVine(data,optimizer)
%%%-----------T - Copula D - Vine likelihood Estimation-----------
% This function estimates the parameters of a D vine assuming that
% all pairs follow a (static) T-Copula
% INPUTS:
% data:             A TxN matrix of U(0,1) or iid margins
% optimizer:        String with values 'fmincon' (default) or 'fminunc'
% method:           If data is U(0,1) method has no meaning. Else if method
%                   is 'CML' the iid are transformed to uniform via
%                   empiricalCDF while if 'IFM' is chosen the
%                   transformation is being made with tinv. 'CML' is the
%                   default.  Advised to always use 'CML'!
% OUTPUT
% logL:             The log likelihood at the optimum
% theta:            The degree of freedom parameters
% ------------------------------------------------------------------------
% Author: Manthos Vogiatzoglou, UoM, 2008 - 2009
% contact at: vogia@yahoo.com
if min(min(data))<0 || max(max(data))>1
    data=empiricalCDF(data);
end
tic
N=size(data,2);
lik=zeros(N-1,N-1);
theta=zeros(N-1,N-1);
u=cell(N,N);

display('computing copula parameters for level 1');
for i=1:N-1
    [theta(1,i),lik(1,i)]=EstimateStaticTCopula([data(:,i),data(:,i+1)],optimizer);
end
rho=corr([data(:,1) data(:,2)]); rho=rho(1,2);
u{1,1}=hfuncTC(data(:,1),data(:,2),theta(1,1),rho);
for k=1:N-3
    rho=corr([data(:,k+1),data(:,k+2)]); rho=rho(1,2);
    u{1,2*k}=hfuncTC(data(:,k+2),data(:,k+1),theta(1,k+1),rho);
    u{1,2*k+1}=hfuncTC(data(:,k+1),data(:,k+2),theta(1,k+1),rho);
end
rho=corr([data(:,N),data(:,N-1)]); rho=rho(1,2);
u{1,2*N-4}=hfuncTC(data(:,N),data(:,N-1),theta(1,N-1),rho);
for j=2:(N-1)
    fprintf(1,'computing copula parameters for level %d\n',j)
    for i=1:(N-j)
        [theta(j,i),lik(j,i)]=EstimateStaticTCopula([u{j-1,2*i-1} u{j-1,2*i}],optimizer);
    end
    if j<N-1
    rho=corr([u{j-1,1},u{j-1,2}]); rho=rho(1,2);
    u{j,1}=hfuncTC(u{j-1,1},u{j-1,2},theta(j,1),rho); 
    if N>4
        for i=1:(N-j-2)
        rho=corr([u{j-1,2*i+2},u{j-1,2*i+1}]); rho=rho(1,2);
        u{j,2*i}=hfuncTC(u{j-1,2*i+2},u{j-1,2*i+1},theta(j,i+1),rho);
        u{j,2*i+1}=hfuncTC(u{j-1,2*i+1},u{j-1,2*i+2},theta(1,k+1),rho);
        end
    end
    rho=corr([u{j-1,2*N-2*j},u{j-1,2*N-2*j-1}]); rho=rho(1,2);
    u{j,2*N-2*j-2}=hfuncTC(u{j-1,2*N-2*j},u{j-1,2*N-2*j-1},theta(j,N-j),rho);
    end
end
logL=sum(sum(lik));   
toc        
    
    